//
//  MPAbstractScroller.h
//  MPServices
//
//  Created by Oleksii Dykan on 11/6/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

IB_DESIGNABLE
@interface MPAbstractScroller : NSScroller

// requires 4 resourses: <imageName>_back, <imageName>_top, <imageName>_center, <imageName>_bottom
@property (nonatomic, copy) IBInspectable NSString *scrollerImagesName;
@property (nonatomic, copy) IBInspectable NSString *backImageName;
@property (nonatomic, strong) IBInspectable NSColor *backColor;
@property (nonatomic, assign) IBInspectable CGFloat cornerRadius;

- (void)commonInit;

+ (CGFloat)defaultScrollerWidth;
+ (void)setDefaultScrollerWidth:(CGFloat)width;

+ (NSString *)defaultScrollerImagesName;
+ (void)setDefaultScrollerImagesName:(NSString *)imagesName;

@end
